# -*- coding: utf-8 -*-
# python环境：python3.7
# apscheduler版本：3.6.1

from apscheduler.schedulers.blocking import BlockingScheduler
from threading import Thread
from datetime import datetime
from datetime import datetime, timedelta
from titan_data_function import Data
from titan_table_structure import Base
import titan_data_settings as settings
import py_eureka_client.eureka_client as eureka_client

class Demo:

    def __init__(self):
        # 创建请求数据线程
        self._thread_data = Thread(target=self.get_data)
        self.go = Data(settings.TS_TOKEN)

    def start(self):
        """
        线程启动函数
        """
        self._thread_data.start()

    def get_calendar(self):
        """
        获取数据
        """
        self.go.get_AShareCalendar("2010-01-01", "2021-02-30", 0)
        print("calendar," + str(datetime.now()))

    def get_month_calendar(self):
        """
        获取Calendar数据
        """
        today = datetime.today()
        start_date, end_date = self.go.get_current_month_start_and_end(str(today))
        self.go.get_AShareCalendar(start_date=start_date, end_date=end_date, type=1)
        print("calendar," + str(datetime.now()))

    def get_description(self):
        """
        获取Description数据
        """
        date = datetime.now()
        self.go.get_AShareDescription(date=date, type=0)
        print("description," + str(datetime.now()))

    def get_data(self):
        """
        使用apscheduler定时框架创建定时任务
        """
        # 创建调度器对象
        scheduler = BlockingScheduler()
        # 添加定时任务 每月1号早上8:30 更新当月交易日历
        scheduler.add_job(self.get_month_calendar, 'cron', month='1-12', day='1', hour='8', minute='30', name="calendar")
        # 添加定时任务 08:00; 09:00;12:30 更新当天A股资料
        scheduler.add_job(self.get_description, 'cron', day_of_week='mon-fri', hour=8, minute=0, name="description")
        scheduler.add_job(self.get_description, 'cron', day_of_week='mon-fri', hour=9, minute=0, name="description")
        scheduler.add_job(self.get_description, 'cron', day_of_week='mon-fri', hour=12, minute=30, name="description")

        # 启动调度器，后台监控定时任务，到点执行
        scheduler.start()

    def setEureka(self):
        server_host = "localhost"
        server_port = 8193
        eureka_client.init(eureka_server="http://admin:pass@localhost:48761/eureka",
                           app_name="titan-data-sync",
                           # 当前组件的主机名，可选参数，如果不填写会自动计算一个，如果服务和 eureka 服务器部署在同一台机器，请必须填写，否则会计算出 127.0.0.1
                           instance_host=server_host,
                           instance_port=server_port,
                           # 调用其他服务时的高可用策略，可选，默认为随机
                           ha_strategy=eureka_client.HA_STRATEGY_RANDOM)

if __name__== '__main__':
    print("start")
    demo = Demo()
    demo.setEureka()
    demo.start()
