package cn.com.titan.eureka.api.utils;

import java.text.NumberFormat;

/**
 * Created by jscat on 2017-05-09.
 */
public class StringUtils extends org.apache.commons.lang3.StringUtils {

    public static String formatPercent(Number value) {
        return formatPercent(value, 1);
    }

    public static String formatPercent(Number value, int maximumFractionDigits) {
        if (value == null) {
            return "0%";
        }

        NumberFormat instance = NumberFormat.getPercentInstance();
        instance.setMaximumFractionDigits(maximumFractionDigits);
        return instance.format(value);
    }

    public static String formatCurrencyHumanReadable(Double value) {
        return formatCurrencyHumanReadable(value, 0);
    }

    public static String formatCurrencyHumanReadable(Double value, int maximumFractionDigits) {
        return formatCurrencyHumanReadable(value, maximumFractionDigits, true, CurrencyUnit.TT, true);
    }

    public static String formatCurrencyHumanReadable(Double value, int maximumFractionDigits, boolean grouping,
                                                     CurrencyUnit currencyUnit, boolean appendUnit) {
        if (value == null) {
            return "0";
        }

        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(maximumFractionDigits);
        format.setGroupingUsed(grouping);

        CurrencyUnit current = currencyUnit;
        do {
            if (Math.abs(value) >= current.value()) {
                return appendUnit ? format.format(value / current.value()) + current.unit() : format.format(value / current.value());
            }
        } while((current = currencyUnit.next(current)) != null);

        return format.format(value);
    }

    public enum CurrencyUnit {

        // 亿 hundred million
        HM(0, 1E8, "亿"),
        // 万 ten thousand
        TT(1, 1E4, "万");

        private static final CurrencyUnit[] CURRENCY_UNIT = new CurrencyUnit[]{HM, TT};

        private int index;

        private double value;

        private String unit;

        CurrencyUnit(int index, double value, String unit) {
            this.index = index;
            this.value = value;
            this.unit = unit;
        }

        public int index() {
            return index;
        }

        public double value() {
            return value;
        }

        public String unit() {
            return unit;
        }

        public CurrencyUnit next(CurrencyUnit current) {
            int nextIndex = current.index() + 1;
            if (nextIndex >= CURRENCY_UNIT.length) {
                return null;
            }
            return CURRENCY_UNIT[nextIndex];
        }

    }

}
