USE sharpe;

/*
	中国A股交易日历, 数据来自wind, baostock or 其他
	tips: 需不需要从多个源获取数据
	
*/

DROP TABLE IF EXISTS tbl_AShareCalendar;
CREATE TABLE tbl_AShareCalendar (
  `OBJECT_ID` VARCHAR(100) COMMENT '对象ID', 
  `TRADE_DAYS` VARCHAR(8) DEFAULT '' COMMENT 'Trading Day, 20210201',
  `S_INFO_EXCHMARKET` VARCHAR(40) DEFAULT '' COMMENT 'Exchange Name (English), SSE:上海交易所 | SZSE：深圳交易所',
  `SOURCE_TYPE` VARCHAR(10) DEFAULT '' COMMENT 'BS: baostock | WD: wind',
  PRIMARY KEY(`TRADE_DAYS`, `S_INFO_EXCHMARKET`),
  KEY `query_key` (`S_INFO_EXCHMARKET`))
  ENGINE=INNODB DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT='交易日历, 每个月1号8:30同步';

/*
	REPLACE INTO tbl_AShareCalendar(OBJECT_ID,TRADE_DAYS, S_INFO_EXCHMARKET, SOURCE_TYPE)
	VALUES("", "20210201", "SSE", "BS"), ("","20210202", "SSE", "BS"), ("","20210202", "SZSE", "BS");

*/