package cn.com.titan.eureka.api.web.common;

import com.netflix.appinfo.InstanceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.eureka.server.event.*;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

@Component
public class EurekaStateChangeListener {

    private static final Logger log = LoggerFactory.getLogger(EurekaStateChangeListener.class);

    @EventListener
    public void listen(EurekaInstanceCanceledEvent eurekaInstanceCanceledEvent) {
        String appName = eurekaInstanceCanceledEvent.getAppName();
        String serverId = eurekaInstanceCanceledEvent.getServerId();
        log.info("module canceled server_id : " + serverId);
        sendCanceledWarnMail(appName,serverId);
    }

    @EventListener
    public void listen(EurekaInstanceRegisteredEvent event) {
        InstanceInfo instanceInfo = event.getInstanceInfo();
        log.info("module registered instanceInfo : " + instanceInfo);
    }

    @EventListener
    public void listen(EurekaInstanceRenewedEvent event) {
        String serverId = event.getServerId();
        log.info("module renewed server_id : " + serverId);
    }

    @EventListener
    public void listen(EurekaRegistryAvailableEvent event) {
        String eventStr = event.toString();
        log.info("module available is " + eventStr);
    }

    @EventListener
    public void listen(EurekaServerStartedEvent event) {
        String startStr = event.toString();
        log.info("module start is " + startStr);
    }

    public void sendCanceledWarnMail(String appName, String serverId)
    {
        Properties props = new Properties();
        // 发送服务器需要身份验证
        props.setProperty("mail.smtp.auth", "true");
        // 设置邮件服务器主机名
        props.setProperty("mail.host", "smtp.163.com");
        // 发送邮件协议名称
        props.setProperty("mail.transport.protocol", "smtp");

        final String smtpPort = "465";
        props.setProperty("mail.smtp.port", smtpPort);
        props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.socketFactory.port", smtpPort);

        try {
            // 设置环境信息
            Session session = Session.getInstance(props);

            // 创建邮件对象
            Message msg = new MimeMessage(session);
            msg.setSubject("Eureka Server status check");
            // 设置邮件内容
            Date day=new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = df.format(day).toString();
            msg.setText("服务异常关闭提醒 appName : " + appName + " , serverId : " + serverId+ " , date : " + date);
            // 设置发件人（账号）
            msg.setFrom(new InternetAddress("titanplus2021@163.com"));

            Transport transport = session.getTransport();
            // 连接邮件服务器(账号，授权码)
            transport.connect("titanplus2021@163.com", "DWSBWWENHZPEUZKB");
            // 发送邮件
            transport.sendMessage(msg, new Address[] {new InternetAddress("jesu@digjob.net")});
            // 关闭连接
            transport.close();
        } catch (Exception e) {
            log.error("send module canceled message error : ", e);
        }
    }
}