package cn.com.titan.eureka.api.web.common;

/**
 * Created by jscat on 2016-12-28.
 */
public class ResponseWrapper<T> {

    private Integer code;

    private String message;

    private String reason;

    private T data;

    public ResponseWrapper() {
        updateResponseState(ResponseCode.OK);
    }

    public ResponseWrapper(ResponseCode responseCode) {
        updateResponseState(responseCode);
    }

    public ResponseWrapper(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public ResponseWrapper(Integer code, String message, String reason) {
        this.code = code;
        this.message = message;
        this.reason = reason;
    }

    public ResponseWrapper(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public void updateResponseState(ResponseCode responseCode) {
        setCode(responseCode.code());
        setMessage(responseCode.message());
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
