package cn.com.titan.eureka.api;

import cn.com.titan.eureka.api.web.common.EurekaStateChangeListener;
import org.junit.Test;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class mailTest {

    private static final Logger log = LoggerFactory.getLogger(mailTest.class);

    @Test
    public void mailTest() throws Exception
    {
        Properties props = new Properties();
        // 发送服务器需要身份验证
        props.setProperty("mail.smtp.auth", "true");
        // 设置邮件服务器主机名
        props.setProperty("mail.host", "smtp.163.com");
        // 发送邮件协议名称
        props.setProperty("mail.transport.protocol", "smtp");

        try {
            // 设置环境信息
            Session session = Session.getInstance(props);

            // 创建邮件对象
            Message msg = new MimeMessage(session);
            msg.setSubject("Eureka Server status check");
            // 设置邮件内容
            msg.setText("服务异常关闭提醒 appName : " + " , serverId : ");
            // 设置发件人（账号）
            msg.setFrom(new InternetAddress("titanplus2021@163.com"));

            Transport transport = session.getTransport();
            // 连接邮件服务器(账号，授权码)
            transport.connect("titanplus2021@163.com", "DWSBWWENHZPEUZKB");
            // 发送邮件
            transport.sendMessage(msg, new Address[] {new InternetAddress("jesu@digjob.net")});
            // 关闭连接
            transport.close();
        } catch (Exception e) {
            log.error("send module canceled message error : ", e);
        }
    }
}
