package cn.com.titan.eureka.api.utils;

import cn.com.titan.eureka.api.common.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * Created by jscat on 2020/4/10
 */


public class BaseUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(BaseUtils.class);

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }
    
    public static HttpSession getSession() {
        return getRequest().getSession();
    }

    public static String getUserIp() {
        String value = getRequest().getHeader("X-Real-IP");
        if (StringUtils.isNotBlank(value) && !"unknown".equalsIgnoreCase(value)) {
            return value;
        } else {
            return getRequest().getRemoteAddr();
        }
    }
    
    public static String getPwd(String password){
    	try {
    		String pwd = MD5Util.encrypt(password+Constants.PASSWORD_KEY);
    		return pwd;
		} catch (Exception e) {
			LOGGER.error("密码加密异常：",e);
		}
    	return null;
    }

    public static String cookieSign(String value){
        try{
            value = value + Constants.PASSWORD_KEY;
            String sign = Des3EncryptionUtil.encode(Constants.DES3_KEY,value);
            return sign;
        }catch (Exception e){
            LOGGER.error("cookie签名异常：",e);
        }
        return null;
    }

}
