USE sharpe;

/*
	AShareDescription
	中国A股基本资料, 数据来自wind, baostock or 其他
	tips: 需不需要从多个源获取数据
	更新时间: 08:00; 09:30; 12:30
	
*/

DROP TABLE IF EXISTS tbl_AShareDescription;
CREATE TABLE tbl_AShareDescription (
  `OBJECT_ID` VARCHAR(100) DEFAULT '' COMMENT '对象ID', 
  `S_INFO_CODE` VARCHAR(40) DEFAULT '' COMMENT '交易代码',
  `S_INFO_NAME` VARCHAR(50) DEFAULT '' COMMENT '证券简称',
  `S_INFO_COMPNAME` VARCHAR(100) DEFAULT '' COMMENT '公司中文名字',
  `S_INFO_COMPNAMEENG` VARCHAR(100) DEFAULT '' COMMENT '公司英文名字',
  `S_INFO_ISINCODE` VARCHAR(40) DEFAULT '' COMMENT 'ISIN CODE',
  `S_INFO_EXCHMARKET` VARCHAR(40) DEFAULT '' COMMENT '交易所, SSE: 上交所; SZSE:深交所',
  `S_INFO_LISTBOARD` VARCHAR(10) DEFAULT '' COMMENT '上市板类型; 434004000:主板; 434003000:中小企业板; 434001000:创业板',
  `S_INFO_LISTBOARDNAME` VARCHAR(10) DEFAULT '' COMMENT '上市板, 主板, 创业板, 中小企业板',
  PRIMARY KEY(`S_INFO_CODE`),
  KEY `query_key` (`S_INFO_CODE`, `S_INFO_NAME`, `S_INFO_COMPNAME`))
  ENGINE=INNODB DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT='中国A股基本资料, 08:00;09:30;12:30';

/*
	REPLACE INTO tbl_AShareDescription(OBJECT_ID,TRADE_DAYS, S_INFO_EXCHMARKET, SOURCE_TYPE)
	VALUES("", "20210201", "SSE", "BS"), ("","20210202", "SSE", "BS"), ("","20210202", "SZSE", "BS");

*/