# encoding=utf-8

import requests
import json
import urllib
import sys


def http_post_request(url, params,add_to_headers=None):
    headers = {
        "Accept": "application/json",
        'Content-Type': 'application/x-www-form-urlencoded'
    }
    if add_to_headers:
        headers.update(add_to_headers)
    postdata = json.dumps(params,ensure_ascii=False)
    print (postdata)
    response = requests.post(url, data=params, headers=headers, timeout=5,verify=False)
    try:
        if response.status_code == 200:
            print (json.dumps(response.json(), encoding="UTF-8", ensure_ascii=False))
            return response.json()
        else:
            return json.dumps({},ensure_ascii=False)
    except BaseException as e:
        print("httpPost failed, detail is:%s,%s" % (response.text, e))
        return