# -*- coding: utf-8 -*-
# python环境：python3.7
# apscheduler版本：3.6.1

from apscheduler.schedulers.blocking import BlockingScheduler
from threading import Thread
from datetime import datetime
from datetime import datetime, timedelta
import pandas as pd
from decimal import *


class Demo:

    def __init__(self):
        # 创建请求数据线程
        self.filename = "input.xlsx"
        self.df_raw = pd.read_excel(self.filename, index_col='id', encoding='utf-8')  # 即指定第一列为行索引
        self.dict_raw = {}
        #用来输出
        self.dict_flat = {}
        #用来比较
        self.dict_ratio = {}
        self.dict_route = {}

    def dict_to_tree(self, dict_o=None):
        """
        dict迭代计算
        :param dict_o:
        :return:
        原字典
            in_data = {
                '上海公司': {
                    '黄浦公司':    20,
                    '张三':       50,
                },
                '黄浦公司': {
                    '张三': 80,
                    '李四': 20
                },
            }
        目标字典
            out_data = {
                '上海公司': {
                    '黄浦公司':    20,
                    '张三':       50+20*80/10000,
                    '李四':       20*20/100/100,
                },
                '黄浦公司': {
                    '张三': 80,
                    '李四': 20
                },
            }

        """
        if not dict_o or not isinstance(dict_o, dict):
            return
        '''
        第一级循环 
            k: 上海公司
            value: {
                    '黄浦公司':    20,
                    '张三':       50,
                },
        '''
        dict_flat = {}
        dict_ratio = {}
        index = 1
        for k, value in dict_o.items():
            if isinstance(value, dict):
                # 递归调用
                print("%s_key: %s" %(index,k))
                di = self._dict_to_tree(value, pre_key=k, pre_str="")
                dict_ratio[k] = di
                dict_flat[k] = sorted(di.items(), key=lambda x: x[1], reverse=True)
                #print(str(index) + "__" + k + "" + str(dict_flat[k]) + "\n\n")
                index = index + 1
        self.dict_ratio = dict_ratio
        return dict_flat

    def _dict_to_tree(self, dict_tmp, target=None, ratio=1.0, level=0, pre_key=None, pre_str=None):
        """
        :param dict_tmp:
        :param target: 最终计算后的持股比例
        :param ratio:  传入下一级的比例值
        :param level:  当前级别
        :param pre_str:
        :return:
        """

        # dict_raw来判断是否有子dict
        dict_raw = self.dict_raw
        # target最终输出
        if target is None:
            target = {}
        if pre_str is None:
            pre_str = ""

        '''
        第二级循环+迭代
        dict_tmp = {
                    '黄浦公司':    20,
                    '张三':       50,
                },
        k: 黄浦公司
        value: 20
        '''
        for k, value in dict_tmp.items():
            # step1: 判断是否存在子dict
            str1 = ""
            if dict_raw.get(k, -1) != -1:
                # 递归调用
                ratio_tmp = ratio
                ratio = value / 100 * ratio

                # 这样基本就是个人持股了
                target[k] = ratio * 100

                print("level_value_ratio_k: level%s %s %s %s" % (str(level), value, ratio, k))
                pre_str = "%s ->(%s)-> %s" % (k, value, pre_key)

                self._dict_to_tree(dict_raw[k], target, ratio, level+1, pre_key=k, pre_str=pre_str)
                # 找到之前的ratio值
                ratio = ratio_tmp
            else:
                # 第三级迭代
                """
                dict_tmp= {
                    '张三': 80,
                    '李四': 20
                }
                k: 张三
                value: 80
                ratio: 20/100
                """
                # 之前存在数据
                if target.get(k, -1) != -1:
                    print("level_value_ratio_target[k]_k: level%d %s %s %s %s" % (level, value, ratio, target[k], k))
                    target[k] = target[k] + value * ratio
                    #print("%s ->(%s)-> " % (k, value))
                    str1 = pre_str
                    pre_str = "%s ->(%s)-> " % (k, value) + str1
                    #print("***"+pre_str)
                else:
                    # 之前不存在数据
                    print("level_value_ratio_k: level%d %s %s %s" % (level, value, ratio, k))
                    target[k] = value * ratio
                    #print("===%s ->(%s)-> " %(k, value))
                    pre_str = "===%s ->(%s)-> " % (k, value)

                if target[k] < 0.0001:
                    target[k] = 0.0001
                print("股权值: %s\n" %target[k])
        return target

    def process_data(self):
        """
        计算数据
        """
        dict = self.dict_raw
        dict_flat = self.dict_to_tree(dict)

        #for验证
        df = pd.DataFrame.from_dict(dict_flat, orient='index', dtype=None, columns=None)
        df.to_csv("output.csv", encoding='utf_8_sig')
        # print(dict_flat)

    def init_data(self):
        """
        使用pandas获取数据
        """
        df = self.df_raw
        dict = {}
        # print(df)
        # print('第0行第1列的数据为：', df.iloc[0, 1])
        # print('"持股比例"列数据为：', df.loc[:, ['持股比例(%)']])
        for row in df.itertuples():
            # print(str(row[1])+"_"+str(row[2])+"_"+str(row[5]))
            dict_tmp = {}
            if dict.get(row[1], -1) != -1:
                dict_tmp = dict[row[1]]
            dict_tmp[row[2]] = row[5]
            dict[row[1]] = dict_tmp
            dict_tmp = {}
        # print(dict)
        self.dict_raw = dict
        dict = {}

    def check1(self, str1, str2):
        """
        核对数据
        for 每个 key
        1. 是否存在
        2. 存在是否>25%
        """
        dict_ratio = self.dict_ratio

        for key in dict_ratio[str1].keys():
            if key in dict_ratio[str2].keys():
                if dict_ratio[str1][key] >= 25 or dict_ratio[str2][key] >= 25:
                    print("    %s 和 %s 存在关联关系" %(str1, str2))
                    print("    %s 持有 %s 股份 %s " % (key, str1, dict_ratio[str1][key]))
                    print("    %s 持有 %s 股份 %s " % (key, str2, dict_ratio[str2][key]))
                else:
                    print("  %s 和 %s 有共同持股股东: %s, 可是不存在关联关系" % (str1, str2, key))
                    print("    %s 持有 %s 股份 %s " % (key, str1, dict_ratio[str1][key]))
                    print("    %s 持有 %s 股份 %s " % (key, str2, dict_ratio[str2][key]))

    def evaluate(self, list1):
        """
        计算数据
        """
        #check1
        # self.check1(list1[0], list1[1])
        for i in range(len(list1)):
            for j in range(i+1, len(list1)):
                # print(str(i)+"_"+str(j))
                self.check1(list1[i], list1[j])


if __name__ == '__main__':
    print("start")
    demo = Demo()
    demo.init_data()
    demo.process_data()
    list1 = ["捷众广告(上海)股份有限公司", "深圳市华语传媒股份有限公司", "分众传媒有限公司", "成都新潮传媒集团有限公司", "城市纵横(上海)文化传媒有限公司"]
    demo.evaluate(list1)
