package cn.com.titan.eureka.api.common;

/**
 * Created by jscat on 2017-05-24.
 * 语句1：select * from student limit 9(offset),4(size)
 * 语句2：select * from student limit 4(size) offset 9(offset)
 * // 语句1和2均返回表student的第10、11、12、13行 ，第一个参数表示从该参数的下一条数据开始，第二个参数表示每次返回的数据条数。
 * //语句2中的4表示返回4行，9表示从表的第十行开始
 */
public class Pagination {

    private Long offset;

    private Integer page;  // 表示页码

    private Integer size;  // 表示每页要显示的条数

    public Pagination(Integer limit) {
        this(Integer.valueOf(1), limit);
    }

    public Pagination(Integer page, Integer size) {
        setPage(page);
        setSize(size);
        setOffset(Long.valueOf(size * (page-1)));
    }

    public Long getOffset() {
        return offset;
    }

    public void setOffset(Long offset) {
        if (offset == null || offset < 0) {
            this.offset = Long.valueOf(0);
        } else {
            this.offset = offset;
        }
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        if (page == null || page < 1) {
            this.page = Integer.valueOf(0);
        } else {
            this.page = page;
        }
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        if (size == null || size < 1) {
            this.size = Integer.valueOf(5);
        } else {
            this.size = size;
        }
    }

    @Override
    public String toString() {
        return "Pagination{" +
                "offset=" + offset +
                ", page=" + page +
                ", size=" + size +
                '}';
    }
}
