package cn.com.titan.eureka.api.web.common;

import cn.com.titan.eureka.api.common.Constants;
import cn.com.titan.eureka.api.utils.DateUtils;
import cn.com.titan.eureka.api.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;

/**
 * Created by jscat on 2017-05-09.
 */
public class DateEditor extends PropertyEditorSupport {

    private static final Logger LOGGER = LoggerFactory.getLogger(DateEditor.class);

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isBlank(text)) {
            setValue(null);
        } else {
            try {
                setValue(DateUtils.parseDate(text, Constants.DATE_PATTERN, Constants.DATETIME_PATTERN));
            } catch (ParseException e) {
                LOGGER.error("error parsing text to date. [{}]", text, e);
                setValue(null);
            }
        }
    }
}
